<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Dialogflow;

class GoogleCloudDialogflowCxV3SpeechToTextSettings extends \Google\Model
{
  /**
   * Whether to use speech adaptation for speech recognition.
   *
   * @var bool
   */
  public $enableSpeechAdaptation;

  /**
   * Whether to use speech adaptation for speech recognition.
   *
   * @param bool $enableSpeechAdaptation
   */
  public function setEnableSpeechAdaptation($enableSpeechAdaptation)
  {
    $this->enableSpeechAdaptation = $enableSpeechAdaptation;
  }
  /**
   * @return bool
   */
  public function getEnableSpeechAdaptation()
  {
    return $this->enableSpeechAdaptation;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(GoogleCloudDialogflowCxV3SpeechToTextSettings::class, 'Google_Service_Dialogflow_GoogleCloudDialogflowCxV3SpeechToTextSettings');
