<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Dataproc;

class AnalyzeOperationMetadata extends \Google\Collection
{
  /**
   * Undefined option
   */
  public const ANALYZED_WORKLOAD_TYPE_WORKLOAD_TYPE_UNSPECIFIED = 'WORKLOAD_TYPE_UNSPECIFIED';
  /**
   * Serverless batch job
   */
  public const ANALYZED_WORKLOAD_TYPE_BATCH = 'BATCH';
  protected $collection_key = 'warnings';
  /**
   * Output only. name of the workload being analyzed.
   *
   * @var string
   */
  public $analyzedWorkloadName;
  /**
   * Output only. Type of the workload being analyzed.
   *
   * @var string
   */
  public $analyzedWorkloadType;
  /**
   * Output only. unique identifier of the workload typically generated by
   * control plane. E.g. batch uuid.
   *
   * @var string
   */
  public $analyzedWorkloadUuid;
  /**
   * Output only. The time when the operation was created.
   *
   * @var string
   */
  public $createTime;
  /**
   * Output only. Short description of the operation.
   *
   * @var string
   */
  public $description;
  /**
   * Output only. The time when the operation finished.
   *
   * @var string
   */
  public $doneTime;
  /**
   * Output only. Labels associated with the operation.
   *
   * @var string[]
   */
  public $labels;
  /**
   * Output only. Warnings encountered during operation execution.
   *
   * @var string[]
   */
  public $warnings;

  /**
   * Output only. name of the workload being analyzed.
   *
   * @param string $analyzedWorkloadName
   */
  public function setAnalyzedWorkloadName($analyzedWorkloadName)
  {
    $this->analyzedWorkloadName = $analyzedWorkloadName;
  }
  /**
   * @return string
   */
  public function getAnalyzedWorkloadName()
  {
    return $this->analyzedWorkloadName;
  }
  /**
   * Output only. Type of the workload being analyzed.
   *
   * Accepted values: WORKLOAD_TYPE_UNSPECIFIED, BATCH
   *
   * @param self::ANALYZED_WORKLOAD_TYPE_* $analyzedWorkloadType
   */
  public function setAnalyzedWorkloadType($analyzedWorkloadType)
  {
    $this->analyzedWorkloadType = $analyzedWorkloadType;
  }
  /**
   * @return self::ANALYZED_WORKLOAD_TYPE_*
   */
  public function getAnalyzedWorkloadType()
  {
    return $this->analyzedWorkloadType;
  }
  /**
   * Output only. unique identifier of the workload typically generated by
   * control plane. E.g. batch uuid.
   *
   * @param string $analyzedWorkloadUuid
   */
  public function setAnalyzedWorkloadUuid($analyzedWorkloadUuid)
  {
    $this->analyzedWorkloadUuid = $analyzedWorkloadUuid;
  }
  /**
   * @return string
   */
  public function getAnalyzedWorkloadUuid()
  {
    return $this->analyzedWorkloadUuid;
  }
  /**
   * Output only. The time when the operation was created.
   *
   * @param string $createTime
   */
  public function setCreateTime($createTime)
  {
    $this->createTime = $createTime;
  }
  /**
   * @return string
   */
  public function getCreateTime()
  {
    return $this->createTime;
  }
  /**
   * Output only. Short description of the operation.
   *
   * @param string $description
   */
  public function setDescription($description)
  {
    $this->description = $description;
  }
  /**
   * @return string
   */
  public function getDescription()
  {
    return $this->description;
  }
  /**
   * Output only. The time when the operation finished.
   *
   * @param string $doneTime
   */
  public function setDoneTime($doneTime)
  {
    $this->doneTime = $doneTime;
  }
  /**
   * @return string
   */
  public function getDoneTime()
  {
    return $this->doneTime;
  }
  /**
   * Output only. Labels associated with the operation.
   *
   * @param string[] $labels
   */
  public function setLabels($labels)
  {
    $this->labels = $labels;
  }
  /**
   * @return string[]
   */
  public function getLabels()
  {
    return $this->labels;
  }
  /**
   * Output only. Warnings encountered during operation execution.
   *
   * @param string[] $warnings
   */
  public function setWarnings($warnings)
  {
    $this->warnings = $warnings;
  }
  /**
   * @return string[]
   */
  public function getWarnings()
  {
    return $this->warnings;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(AnalyzeOperationMetadata::class, 'Google_Service_Dataproc_AnalyzeOperationMetadata');
