<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Compute;

class InstantSnapshot extends \Google\Model
{
  /**
   * Default value indicating Architecture is not set.
   */
  public const ARCHITECTURE_ARCHITECTURE_UNSPECIFIED = 'ARCHITECTURE_UNSPECIFIED';
  /**
   * Machines with architecture ARM64
   */
  public const ARCHITECTURE_ARM64 = 'ARM64';
  /**
   * Machines with architecture X86_64
   */
  public const ARCHITECTURE_X86_64 = 'X86_64';
  /**
   * InstantSnapshot creation is in progress.
   */
  public const STATUS_CREATING = 'CREATING';
  /**
   * InstantSnapshot is currently being deleted.
   */
  public const STATUS_DELETING = 'DELETING';
  /**
   * InstantSnapshot creation failed.
   */
  public const STATUS_FAILED = 'FAILED';
  /**
   * InstantSnapshot has been created successfully.
   */
  public const STATUS_READY = 'READY';
  /**
   * InstantSnapshot is currently unavailable and cannot be used for Disk
   * restoration
   */
  public const STATUS_UNAVAILABLE = 'UNAVAILABLE';
  /**
   * [Output Only] The architecture of the instant snapshot. Valid values are
   * ARM64 or X86_64.
   *
   * @var string
   */
  public $architecture;
  /**
   * [Output Only] Creation timestamp inRFC3339 text format.
   *
   * @var string
   */
  public $creationTimestamp;
  /**
   * An optional description of this resource. Provide this property when you
   * create the resource.
   *
   * @var string
   */
  public $description;
  /**
   * [Output Only] Size of the source disk, specified in GB.
   *
   * @var string
   */
  public $diskSizeGb;
  /**
   * [Output Only] The unique identifier for the resource. This identifier is
   * defined by the server.
   *
   * @var string
   */
  public $id;
  /**
   * [Output Only] Type of the resource. Alwayscompute#instantSnapshot for
   * InstantSnapshot resources.
   *
   * @var string
   */
  public $kind;
  /**
   * A fingerprint for the labels being applied to this InstantSnapshot, which
   * is essentially a hash of the labels set used for optimistic locking. The
   * fingerprint is initially generated by Compute Engine and changes after
   * every request to modify or update labels. You must always provide an up-to-
   * date fingerprint hash in order to update or change labels, otherwise the
   * request will fail with error412 conditionNotMet.
   *
   * To see the latest fingerprint, make a get() request to retrieve a
   * InstantSnapshot.
   *
   * @var string
   */
  public $labelFingerprint;
  /**
   * Labels to apply to this InstantSnapshot. These can be later modified by the
   * setLabels method. Label values may be empty.
   *
   * @var string[]
   */
  public $labels;
  /**
   * Name of the resource; provided by the client when the resource is created.
   * The name must be 1-63 characters long, and comply withRFC1035.
   * Specifically, the name must be 1-63 characters long and match the regular
   * expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character
   * must be a lowercase letter, and all following characters must be a dash,
   * lowercase letter, or digit, except the last character, which cannot be a
   * dash.
   *
   * @var string
   */
  public $name;
  /**
   * [Output Only] URL of the region where the instant snapshot resides. You
   * must specify this field as part of the HTTP request URL. It is not settable
   * as a field in the request body.
   *
   * @var string
   */
  public $region;
  protected $resourceStatusType = InstantSnapshotResourceStatus::class;
  protected $resourceStatusDataType = '';
  /**
   * Output only. Reserved for future use.
   *
   * @var bool
   */
  public $satisfiesPzi;
  /**
   * [Output Only] Reserved for future use.
   *
   * @var bool
   */
  public $satisfiesPzs;
  /**
   * [Output Only] Server-defined URL for the resource.
   *
   * @var string
   */
  public $selfLink;
  /**
   * [Output Only] Server-defined URL for this resource's resource id.
   *
   * @var string
   */
  public $selfLinkWithId;
  /**
   * URL of the source disk used to create this instant snapshot. Note that the
   * source disk must be in the same zone/region as the instant snapshot to be
   * created. This can be a full or valid partial URL. For example, the
   * following are valid values:              -         https://www.googleapis.c
   * om/compute/v1/projects/project/zones/zone/disks/disk            -         h
   * ttps://www.googleapis.com/compute/v1/projects/project/regions/region/disks/
   * disk            -         projects/project/zones/zone/disks/disk
   * -         projects/project/regions/region/disks/disk            -
   * zones/zone/disks/disk            -         regions/region/disks/disk
   *
   * @var string
   */
  public $sourceDisk;
  /**
   * [Output Only] The ID value of the disk used to create this InstantSnapshot.
   * This value may be used to determine whether the InstantSnapshot was taken
   * from the current or a previous instance of a given disk name.
   *
   * @var string
   */
  public $sourceDiskId;
  /**
   * [Output Only] The status of the instantSnapshot. This can beCREATING,
   * DELETING, FAILED, orREADY.
   *
   * @var string
   */
  public $status;
  /**
   * [Output Only] URL of the zone where the instant snapshot resides. You must
   * specify this field as part of the HTTP request URL. It is not settable as a
   * field in the request body.
   *
   * @var string
   */
  public $zone;

  /**
   * [Output Only] The architecture of the instant snapshot. Valid values are
   * ARM64 or X86_64.
   *
   * Accepted values: ARCHITECTURE_UNSPECIFIED, ARM64, X86_64
   *
   * @param self::ARCHITECTURE_* $architecture
   */
  public function setArchitecture($architecture)
  {
    $this->architecture = $architecture;
  }
  /**
   * @return self::ARCHITECTURE_*
   */
  public function getArchitecture()
  {
    return $this->architecture;
  }
  /**
   * [Output Only] Creation timestamp inRFC3339 text format.
   *
   * @param string $creationTimestamp
   */
  public function setCreationTimestamp($creationTimestamp)
  {
    $this->creationTimestamp = $creationTimestamp;
  }
  /**
   * @return string
   */
  public function getCreationTimestamp()
  {
    return $this->creationTimestamp;
  }
  /**
   * An optional description of this resource. Provide this property when you
   * create the resource.
   *
   * @param string $description
   */
  public function setDescription($description)
  {
    $this->description = $description;
  }
  /**
   * @return string
   */
  public function getDescription()
  {
    return $this->description;
  }
  /**
   * [Output Only] Size of the source disk, specified in GB.
   *
   * @param string $diskSizeGb
   */
  public function setDiskSizeGb($diskSizeGb)
  {
    $this->diskSizeGb = $diskSizeGb;
  }
  /**
   * @return string
   */
  public function getDiskSizeGb()
  {
    return $this->diskSizeGb;
  }
  /**
   * [Output Only] The unique identifier for the resource. This identifier is
   * defined by the server.
   *
   * @param string $id
   */
  public function setId($id)
  {
    $this->id = $id;
  }
  /**
   * @return string
   */
  public function getId()
  {
    return $this->id;
  }
  /**
   * [Output Only] Type of the resource. Alwayscompute#instantSnapshot for
   * InstantSnapshot resources.
   *
   * @param string $kind
   */
  public function setKind($kind)
  {
    $this->kind = $kind;
  }
  /**
   * @return string
   */
  public function getKind()
  {
    return $this->kind;
  }
  /**
   * A fingerprint for the labels being applied to this InstantSnapshot, which
   * is essentially a hash of the labels set used for optimistic locking. The
   * fingerprint is initially generated by Compute Engine and changes after
   * every request to modify or update labels. You must always provide an up-to-
   * date fingerprint hash in order to update or change labels, otherwise the
   * request will fail with error412 conditionNotMet.
   *
   * To see the latest fingerprint, make a get() request to retrieve a
   * InstantSnapshot.
   *
   * @param string $labelFingerprint
   */
  public function setLabelFingerprint($labelFingerprint)
  {
    $this->labelFingerprint = $labelFingerprint;
  }
  /**
   * @return string
   */
  public function getLabelFingerprint()
  {
    return $this->labelFingerprint;
  }
  /**
   * Labels to apply to this InstantSnapshot. These can be later modified by the
   * setLabels method. Label values may be empty.
   *
   * @param string[] $labels
   */
  public function setLabels($labels)
  {
    $this->labels = $labels;
  }
  /**
   * @return string[]
   */
  public function getLabels()
  {
    return $this->labels;
  }
  /**
   * Name of the resource; provided by the client when the resource is created.
   * The name must be 1-63 characters long, and comply withRFC1035.
   * Specifically, the name must be 1-63 characters long and match the regular
   * expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character
   * must be a lowercase letter, and all following characters must be a dash,
   * lowercase letter, or digit, except the last character, which cannot be a
   * dash.
   *
   * @param string $name
   */
  public function setName($name)
  {
    $this->name = $name;
  }
  /**
   * @return string
   */
  public function getName()
  {
    return $this->name;
  }
  /**
   * [Output Only] URL of the region where the instant snapshot resides. You
   * must specify this field as part of the HTTP request URL. It is not settable
   * as a field in the request body.
   *
   * @param string $region
   */
  public function setRegion($region)
  {
    $this->region = $region;
  }
  /**
   * @return string
   */
  public function getRegion()
  {
    return $this->region;
  }
  /**
   * [Output Only] Status information for the instant snapshot resource.
   *
   * @param InstantSnapshotResourceStatus $resourceStatus
   */
  public function setResourceStatus(InstantSnapshotResourceStatus $resourceStatus)
  {
    $this->resourceStatus = $resourceStatus;
  }
  /**
   * @return InstantSnapshotResourceStatus
   */
  public function getResourceStatus()
  {
    return $this->resourceStatus;
  }
  /**
   * Output only. Reserved for future use.
   *
   * @param bool $satisfiesPzi
   */
  public function setSatisfiesPzi($satisfiesPzi)
  {
    $this->satisfiesPzi = $satisfiesPzi;
  }
  /**
   * @return bool
   */
  public function getSatisfiesPzi()
  {
    return $this->satisfiesPzi;
  }
  /**
   * [Output Only] Reserved for future use.
   *
   * @param bool $satisfiesPzs
   */
  public function setSatisfiesPzs($satisfiesPzs)
  {
    $this->satisfiesPzs = $satisfiesPzs;
  }
  /**
   * @return bool
   */
  public function getSatisfiesPzs()
  {
    return $this->satisfiesPzs;
  }
  /**
   * [Output Only] Server-defined URL for the resource.
   *
   * @param string $selfLink
   */
  public function setSelfLink($selfLink)
  {
    $this->selfLink = $selfLink;
  }
  /**
   * @return string
   */
  public function getSelfLink()
  {
    return $this->selfLink;
  }
  /**
   * [Output Only] Server-defined URL for this resource's resource id.
   *
   * @param string $selfLinkWithId
   */
  public function setSelfLinkWithId($selfLinkWithId)
  {
    $this->selfLinkWithId = $selfLinkWithId;
  }
  /**
   * @return string
   */
  public function getSelfLinkWithId()
  {
    return $this->selfLinkWithId;
  }
  /**
   * URL of the source disk used to create this instant snapshot. Note that the
   * source disk must be in the same zone/region as the instant snapshot to be
   * created. This can be a full or valid partial URL. For example, the
   * following are valid values:              -         https://www.googleapis.c
   * om/compute/v1/projects/project/zones/zone/disks/disk            -         h
   * ttps://www.googleapis.com/compute/v1/projects/project/regions/region/disks/
   * disk            -         projects/project/zones/zone/disks/disk
   * -         projects/project/regions/region/disks/disk            -
   * zones/zone/disks/disk            -         regions/region/disks/disk
   *
   * @param string $sourceDisk
   */
  public function setSourceDisk($sourceDisk)
  {
    $this->sourceDisk = $sourceDisk;
  }
  /**
   * @return string
   */
  public function getSourceDisk()
  {
    return $this->sourceDisk;
  }
  /**
   * [Output Only] The ID value of the disk used to create this InstantSnapshot.
   * This value may be used to determine whether the InstantSnapshot was taken
   * from the current or a previous instance of a given disk name.
   *
   * @param string $sourceDiskId
   */
  public function setSourceDiskId($sourceDiskId)
  {
    $this->sourceDiskId = $sourceDiskId;
  }
  /**
   * @return string
   */
  public function getSourceDiskId()
  {
    return $this->sourceDiskId;
  }
  /**
   * [Output Only] The status of the instantSnapshot. This can beCREATING,
   * DELETING, FAILED, orREADY.
   *
   * Accepted values: CREATING, DELETING, FAILED, READY, UNAVAILABLE
   *
   * @param self::STATUS_* $status
   */
  public function setStatus($status)
  {
    $this->status = $status;
  }
  /**
   * @return self::STATUS_*
   */
  public function getStatus()
  {
    return $this->status;
  }
  /**
   * [Output Only] URL of the zone where the instant snapshot resides. You must
   * specify this field as part of the HTTP request URL. It is not settable as a
   * field in the request body.
   *
   * @param string $zone
   */
  public function setZone($zone)
  {
    $this->zone = $zone;
  }
  /**
   * @return string
   */
  public function getZone()
  {
    return $this->zone;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(InstantSnapshot::class, 'Google_Service_Compute_InstantSnapshot');
