<?php

declare(strict_types=1);

namespace CuyZ\Valinor\Compiler\Native;

use CuyZ\Valinor\Compiler\Compiler;
use CuyZ\Valinor\Compiler\Node;

/** @internal */
final class ClassNameNode extends Node
{
    public function __construct(
        /** @var class-string */
        private string $className,
    ) {}

    public function compile(Compiler $compiler): Compiler
    {
        return $compiler->write($this->className . '::class');
    }
}
